/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.export.pdf;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import cz.insophy.inplan.export.TableWriter;
import cz.insophy.inplan.export.pdf.PdfCell;
import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.html.CssColorParser;
import java.awt.Color;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PdfTableItextWriter
extends TableWriter {
    @Nonnull
    private final String documentTitle;
    private String tableTitle;
    @Nonnull
    private final String pageOrientation;
    private final List<PdfCell> row = Lists.newArrayList();
    private final List<String> headers = Lists.newArrayList();
    private boolean initNeeded = false;
    private final Document document;
    private PdfWriter pdfWriter;
    private final List<InPdfPTable> tables = Lists.newArrayList();
    private InPdfPTable table = null;
    private Font cellFont;
    private Font linkFont;
    private Font annotationFont;
    private Font headerFont;
    private Font titleFont;
    private Font subtitleFont;
    private float[] widths = null;
    private final Map<String, Font> cellColoredFonts = Maps.newHashMap();

    public PdfTableItextWriter(@Nonnull OutputStream target, @Nonnull String documentTitle, @Nullable String pageOrientation, @Nullable String fontSize) {
        float cellFontSize;
        Preconditions.checkNotNull(target);
        this.documentTitle = documentTitle;
        this.pageOrientation = Strings.isNullOrEmpty(pageOrientation) ? "landscape" : pageOrientation;
        this.document = new Document(this.pageOrientation.equals("portrait") ? PageSize.A4 : PageSize.A4.rotate());
        if (Strings.isNullOrEmpty(fontSize)) {
            cellFontSize = 10.0f;
        } else {
            cellFontSize = switch (fontSize) {
                case "small" -> 7.0f;
                case "big" -> 12.0f;
                default -> 10.0f;
            };
        }
        try {
            BaseFont font = BaseFont.createFont((String)this.getClass().getResource("DejaVuLGCSans.ttf").toString(), (String)"Identity-H", (boolean)true);
            this.cellFont = new Font(font, cellFontSize);
            this.linkFont = new Font(font, cellFontSize, 0, Color.BLUE);
            this.annotationFont = new Font(font, cellFontSize, 4);
            Font headerFooterFont = new Font(font, 9.0f);
            this.titleFont = new Font(font, 20.0f);
            font = BaseFont.createFont((String)this.getClass().getResource("DejaVuLGCSans-Bold.ttf").toString(), (String)"Identity-H", (boolean)true);
            this.headerFont = new Font(font, cellFontSize);
            this.subtitleFont = new Font(font, 12.0f, 2);
            this.pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)target);
            HeaderFooter header = new HeaderFooter(new Phrase(this.tableTitle, headerFooterFont), false);
            header.setBorder(0);
            header.setAlignment(2);
            this.document.setHeader(header);
            HeaderFooter footer = new HeaderFooter(new Phrase("-", headerFooterFont), new Phrase("-", headerFooterFont));
            footer.setBorder(0);
            footer.setAlignment(1);
            this.document.setFooter(footer);
            this.document.open();
            this.document.addTitle(documentTitle);
            this.document.addAuthor("inSophy s.r.o.");
            this.document.addCreator("Plantune");
        }
        catch (Exception e) {
            this.addError("Error initializing iText PDF exporter", e.getMessage());
        }
    }

    private void initTable() {
        this.widths = new float[this.headers.size()];
        this.table = new InPdfPTable(this.headers.size(), this.tableTitle);
        this.table.setHeaderRows(1);
        this.table.setWidthPercentage(100.0f);
        for (String header : this.headers) {
            PdfPCell c = new PdfPCell((Phrase)new Paragraph(header, this.headerFont));
            c.setPadding(4.0f);
            c.setPaddingBottom(6.0f);
            this.table.addCell(c);
        }
    }

    @Override
    public void newSheet(String title) {
        this.finishActualTable();
        this.initNeeded = false;
        this.tableTitle = title;
    }

    @Override
    public boolean newRow() {
        if (this.initNeeded) {
            this.initTable();
            this.initNeeded = false;
        }
        this.flushRow();
        return true;
    }

    private void flushRow() {
        int i = 0;
        for (PdfCell cell : this.row) {
            this.addCell(cell);
            this.updateWidths(i, cell);
            ++i;
        }
        this.row.clear();
    }

    private void updateWidths(int i, PdfCell cell) {
        float w = ColumnText.getWidth((Phrase)cell.getPhrase());
        if (w > this.widths[i]) {
            this.widths[i] = w;
        }
    }

    private Font getColorFont(String color) {
        if (Strings.isNullOrEmpty(color)) {
            return null;
        }
        if (this.cellColoredFonts.containsKey(color)) {
            return this.cellColoredFonts.get(color);
        }
        Color c = CssColorParser.toColor(color);
        if (c != null) {
            Font newFont = new Font(this.cellFont);
            newFont.setColor(c);
            this.cellColoredFonts.put(color, newFont);
            return newFont;
        }
        return null;
    }

    private void addCell(PdfCell cell) {
        Paragraph par = new Paragraph();
        par.add((Object)cell.getPhrase());
        par.setAlignment(2);
        if (cell.getProps() == null) {
            this.table.addCell((Phrase)par);
            return;
        }
        String bgColStr = cell.getProps().bckgColor;
        Color backgroundColor = Strings.isNullOrEmpty(bgColStr) ? null : CssColorParser.toColor(bgColStr);
        Font colorFont = this.getColorFont(cell.getProps().txtColor);
        if (colorFont != null) {
            for (Chunk chunk : Iterables.filter(par, Chunk.class)) {
                chunk.setFont(colorFont);
                if (backgroundColor == null) continue;
                chunk.setBackground(Color.WHITE);
            }
        }
        PdfPCell c = new PdfPCell((Phrase)par);
        if (backgroundColor != null) {
            c.setBackgroundColor(backgroundColor);
        }
        if (cell.isTopBorder()) {
            c.setBorderWidthTop(2.0f);
        }
        if (cell.isAlignRight()) {
            c.setHorizontalAlignment(2);
        }
        c.setPadding(4.0f);
        c.setPaddingBottom(6.0f);
        this.table.addCell(c);
    }

    private void newCell(@Nonnull String value, TableWriter.CellProperties props, boolean alignRight) {
        Preconditions.checkNotNull(value);
        Preconditions.checkState(this.row.size() < this.headers.size());
        this.row.add(new PdfCell(value.trim(), this.cellFont, props, alignRight));
    }

    @Override
    public void newHeaderCell(@Nonnull String title) {
        Preconditions.checkNotNull(title);
        this.headers.add(title);
        this.initNeeded = true;
    }

    @Override
    public void newStringCell(String value, TableWriter.CellProperties props) {
        this.newCell(value == null ? "" : ReportUtilities.stripHtml(value), props, false);
    }

    @Override
    public void newDateCell(Long date, TableWriter.CellProperties props) {
        if (date == null || !GeneralizedRequest.isDateValid(date)) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatMediumDate(date), props, false);
        }
    }

    @Override
    public void newDatetimeCell(Long date, TableWriter.CellProperties props) {
        if (date == null || !GeneralizedRequest.isDateValid(date)) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatMediumDateTime(date), props, false);
        }
    }

    @Override
    public void newTimeCell(Long date, TableWriter.CellProperties props) {
        if (date == null || !GeneralizedRequest.isDateValid(date)) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatTime(date), props, false);
        }
    }

    @Override
    public void newDurationInDayCell(Long duration, TableWriter.CellProperties props) {
        if (duration == null || !GeneralizedRequest.isDateValid(duration)) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatDurationDay(duration), props, true);
        }
    }

    @Override
    public void newDurationInHourCell(Long duration, TableWriter.CellProperties props) {
        if (duration == null || !GeneralizedRequest.isDateValid(duration)) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatDurationHour(duration), props, true);
        }
    }

    @Override
    public void newDurationCell(Long duration, TableWriter.CellProperties props) {
        if (duration == null || !GeneralizedRequest.isDateValid(duration)) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatDuration(duration), props, true);
        }
    }

    @Override
    public void newBooleanCell(Boolean value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell(value != false ? Formatter.getSymbols().getBooleanTrue() : Formatter.getSymbols().getBooleanFalse(), props, false);
        }
    }

    @Override
    public boolean canWriteStatistics() {
        return true;
    }

    @Override
    public void addStatisticsFormula(TableWriter.ColumnStatisticsType type) {
        this.row.get(this.row.size() - 1).setTopBorder(true);
    }

    @Override
    public void newIntegerCell(Long value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatNumber(value), props, true);
        }
    }

    @Override
    public void newFloatCell(Double value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatNumber(value), props, true);
        }
    }

    @Override
    public void newPercentCell(Double value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatPercent(value), props, true);
        }
    }

    @Override
    public void newColorCell(Color value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell("#" + Integer.toHexString(value.getRGB()), props, false);
        }
    }

    @Override
    public void newEmptyCell(TableWriter.CellProperties props) {
        this.newCell("", props, false);
    }

    @Override
    public boolean addMultipleLinks(@Nonnull List<TableWriter.CellLink> links) {
        return false;
    }

    @Override
    public void addLink(@Nonnull String absoluteUrl, @Nullable TableWriter.CellProperties props) {
        try {
            Phrase phrase = this.row.get(this.row.size() - 1).getPhrase();
            for (Chunk chunk : Iterables.filter(phrase, Chunk.class)) {
                chunk.setFont(this.linkFont);
                chunk.setAnchor(absoluteUrl);
            }
        }
        catch (Exception e) {
            this.addError("Error adding link", "Failed add URL:'" + absoluteUrl + "', " + e.getMessage());
        }
    }

    @Override
    public void addDescription(String text, boolean useMonospaceFont) {
        if (useMonospaceFont) {
            return;
        }
        if ((text = ReportUtilities.stripHtml(Strings.nullToEmpty(text))).isEmpty()) {
            return;
        }
        Phrase phrase = this.row.get(this.row.size() - 1).getPhrase();
        Chunk chunk = Iterables.getFirst(Iterables.filter(phrase, Chunk.class), null);
        if (chunk == null) {
            chunk = new Chunk("\u00a0", this.cellFont);
            phrase.add((Object)chunk);
        }
        PdfAnnotation annotation = PdfAnnotation.createSquareCircle((PdfWriter)this.pdfWriter, null, (String)text, (boolean)true);
        annotation.setTitle(chunk.getContent());
        chunk.setAnnotation(annotation);
        chunk.setFont(this.annotationFont);
    }

    private void finishActualTable() {
        if (this.initNeeded) {
            this.initTable();
        }
        if (this.table == null) {
            return;
        }
        this.flushRow();
        if (this.table.size() == 1) {
            for (int i = 0; i < this.table.getNumberOfColumns(); ++i) {
                this.table.addCell("");
            }
        }
        float minWidth = new Chunk("00.00.0000", this.cellFont).getWidthPoint();
        float maxWidth = new Chunk(this.pageOrientation.equals("portrait") ? "00.00.0000 00.00.0000" : "00.00.0000 00.00.0000 00.00.0000", this.cellFont).getWidthPoint();
        for (int i = 0; i < this.widths.length; ++i) {
            this.widths[i] = Math.min(maxWidth, Math.max(this.widths[i], minWidth));
        }
        try {
            this.table.setWidths(this.widths);
        }
        catch (DocumentException e) {
            this.addError("Error processing table export with iText", e.getMessage());
        }
        this.tables.add(this.table);
        this.table = null;
        this.headers.clear();
    }

    @Override
    public void closeWriter() {
        this.finishActualTable();
        try {
            Paragraph title = new Paragraph(this.documentTitle, this.titleFont);
            title.setSpacingAfter(6.0f);
            this.document.add((Element)title);
            for (int i = 0; i < this.tables.size(); ++i) {
                InPdfPTable t = this.tables.get(i);
                if (i != 0) {
                    this.document.newPage();
                }
                if (this.tables.size() > 1) {
                    Paragraph tt = new Paragraph(t.getTitle(), this.subtitleFont);
                    tt.setSpacingAfter(5.0f);
                    this.document.add((Element)tt);
                }
                this.document.add((Element)t);
            }
        }
        catch (DocumentException e) {
            this.addError("Error processing table export with iText", e.getMessage());
        }
        this.document.close();
    }

    @Override
    public void newNhCell(Long value, TableWriter.CellProperties props) {
        if (value == null) {
            this.newEmptyCell(props);
        } else {
            this.newCell(Formatter.formatDurationNh(value), props, true);
        }
    }

    private static class InPdfPTable
    extends PdfPTable {
        private final String title;

        InPdfPTable(int columns, String title) {
            super(columns);
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

